package gov.va.med.mhv.usermgmt.service.handler;

import gov.va.oit.oed.vaww.VAIdMPort;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import javax.xml.namespace.QName;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.atlas.config.ConfigurationManager;

public class MviInvocationUtilHandler implements GenericMessageHandler{
	
	private static final Log LOG = LogFactory.getLog(MviInvocationUtilHandler.class);
	// Configuration Properties
	//MviProperties properties = MviProperties.getInstance();
	public String wsdlURL;
	//public static final String wsdlURL="http://serverserver1.abc.domain.ext:0000/psim_webservice/IdMWebService?WSDL";
	//public static final String wsdlURL="http://server.commserv.healtheman.domain:0000/psim_webservice/PSIMWebService?WSDL";
	public static final String namespace ="http://wwww.abc.domain.ext";
	public static final String serviceName="VAIdM";
	public static final String portName="VAIdMPort";

	public static String rawXML;
		
	public MviInvocationUtilHandler() {
		
		//this.wsdlURL = wsdlURL;
		//this.rawXML = rawXML;
	}
	
	public String invokeMvi(String requestType, Object reqXML) {

		QName serviceQN= new QName(namespace, serviceName);
		String finalSoapBody = null;
		SOAPMviHandlerResolver handlerResolver = new SOAPMviHandlerResolver(this);
		try {
			long startTime = System.currentTimeMillis();
			VAIdMPort mviProxy = getVAIdMPort(handlerResolver);
			long endTime = System.currentTimeMillis();
			if(LOG.isDebugEnabled())
				LOG.debug("Time taken to execute getVAIdMPort: " +(endTime-startTime) + " ms");
			if(mviProxy != null) {
				//Object response = mviProxy.PRPA_IN201305UV02(createStubRequest());
				Class c = mviProxy.getClass();
				//Class c = Class.forName("gov.va.oit.oed.vaww.VAIdMPort");
				Method  method = c.getMethod(requestType, new Class[] { Object.class });
				Object response = method.invoke(mviProxy, reqXML);
				/*
				System.out.println("OBJ: " +response.toString());
				System.out.println("RAWXML: " +this.rawXML);
				int startIndex = this.rawXML.indexOf("<idm:PRPA_");
				int endIndex = this.rawXML.indexOf("</env:Body>");
				finalSoapBody = this.rawXML.substring(startIndex, endIndex);
				*/
				finalSoapBody =this.rawXML;
				if(LOG.isDebugEnabled())
					LOG.debug("Local Raw XML: " +this.rawXML);
				//System.out.println("Resolver Raw XML: " +handlerResolver.rawXML);
				if(LOG.isDebugEnabled())
					LOG.debug("finalSoapBody: " +finalSoapBody);
				return finalSoapBody;
			}	
		}
			//catch (RemoteException e) {
				// TODO Auto-generated catch block
			//	e.printStackTrace();
			//} 
			//catch (ServiceException e) {
				// TODO Auto-generated catch block
			//	e.printStackTrace();
			//} 
		catch (SecurityException e) {
				// TODO Auto-generated catch block
			e.printStackTrace();
			return "ERROR";
		} catch (NoSuchMethodException e) {
				// TODO Auto-generated catch block
			e.printStackTrace();
			return "ERROR";
		} catch (IllegalArgumentException e) {
				// TODO Auto-generated catch block
			e.printStackTrace();
			return "ERROR";
		} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
			e.printStackTrace();
			return "ERROR";
		} catch (InvocationTargetException e) {
				// TODO Auto-generated catch block
			e.printStackTrace();
			return "ERROR";
		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return "ERROR";
		} catch (Exception eX) {
			eX.printStackTrace();
			return "ERROR";
		}
				
		return finalSoapBody;

	}
	
	private enum ENVTYPES { DEV("dev"), INTB("intb"), SYSTEST("systest"), PREPROD("preprod"), PROD("prod"); 
		private String envValue;
    	private ENVTYPES(String value) {
    		this.envValue = value;
    	}
    	public String value(){
    		return envValue;
    		}
	};

	ThreadLocal<VAIdMPort> mviProxy = new ThreadLocal<VAIdMPort>();
	public VAIdMPort getVAIdMPort(SOAPMviHandlerResolver handlerResolver) throws MalformedURLException, Exception{
		MviProperties properties = MviProperties.getInstance();
		javax.xml.ws.Service service = null;
		/*
		if(properties.getIsMviProdEnv()) {
			wsdlURL = properties.getMviProdWsdlurl();
		}
		else
			wsdlURL = properties.getMviTestWsdlurl();
		*/
		String envType = properties.getMviEnvType();
		ENVTYPES selectedEnv = null;
		 for (ENVTYPES envTypes: ENVTYPES.values()) {
			 if(envTypes.value().equalsIgnoreCase(envType))
				 selectedEnv = envTypes;
		 }
		//ENVTYPES envTypes	= ENVTYPES.(envType);
 		switch (selectedEnv) {
			case DEV:
				wsdlURL = properties.getMviDevWsdlurl();
				break;
			case INTB:
				wsdlURL = properties.getMviIntbWsdlurl();
				break;	
			case SYSTEST:	
				wsdlURL = properties.getMviSysTestWsdlurl();
				break;
			case PREPROD:	
				wsdlURL = properties.getMviPreProdWsdlurl();
				break;
			case PROD:	
				wsdlURL = properties.getMviProdWsdlurl();
				break;
			default:	
 		}		
//		if (mviProxy.get() == null || properties.getIsReloadRequired()) {
			
			ThreadLocal<VAIdMPort> port = new ThreadLocal<VAIdMPort>();;
			
			QName portQN = new QName(namespace, portName);
			QName serviceQN= new QName(namespace, serviceName);
			Integer conn_timeout = properties.getMviConnectTimeout();
			Integer req_timeout = properties.getMviRequestTimeout();
	
			//try {
				long startTime1 = System.currentTimeMillis();
				service = javax.xml.ws.Service.create(new URL(wsdlURL), serviceQN);
				long startTime2 = System.currentTimeMillis();
				if(LOG.isDebugEnabled())
					LOG.debug("Time taken to execute 1st Step: " +(startTime2-startTime1));
				service.setHandlerResolver(handlerResolver);
				port.set((VAIdMPort)service.getPort(portQN, VAIdMPort.class));
				long startTime3 = System.currentTimeMillis();
				if(LOG.isDebugEnabled())
					LOG.debug("Time taken to execute 2nd Step: " +(startTime3-startTime2));
				//BindingProvider bindingProvider = (BindingProvider)service;
				//final Binding binding = bindingProvider.getBinding();
				Binding binding = ((BindingProvider)port.get()).getBinding();
								
				//Connection Timeout in millisecond
				((BindingProvider)port.get()).getRequestContext().put("com.sun.xml.ws.connect.timeout", conn_timeout * 1000);
	
				//Request Timeout in millisecond
				((BindingProvider)port.get()).getRequestContext().put("com.sun.xml.ws.request.timeout", req_timeout * 1000);
				
				/*
				List<Handler> handlerList = binding.getHandlerChain();
				if (handlerList == null)
					handlerList = new ArrayList<Handler>();
	
				handlerList.add(new gov.va.med.mhv.usermgmt.service.handler.SOAPMviMessageHandler(this));
				handlerList.add(new SOAPMviLoggingHandler());
				binding.setHandlerChain(handlerList);
				*/
			/*	
			} catch (MalformedURLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			catch (Exception e) {
				e.printStackTrace();
				return null;
			}
			*/
//		mviProxy = port;
//		return port.get();
//		}
//		else 
//		return mviProxy.get();
		return port.get();		

	}

	
	public String getRawXML() {
		return rawXML;
	}
	
	public void setRawXml(String xml) {
		this.rawXML = xml;
		
	}
	
}
